/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.blocks.tiles;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.Server;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.handler.data.IQuestObjective;
import noppes.npcs.blocks.tiles.TileNpcEntity;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumQuestTask;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerQuestData;
import noppes.npcs.controllers.data.QuestData;
import noppes.npcs.quests.QuestInterface;
import noppes.npcs.quests.QuestObjective;

public class TileWaypoint
extends TileNpcEntity
implements ITickable {
    public String name = "";
    public int range = 10;
    private List<EntityPlayer> recentlyChecked = new ArrayList<EntityPlayer>();
    private int ticks = 10;

    private List<EntityPlayer> getPlayerList(int x, int y, int z) {
        List<Object> list = new ArrayList<EntityPlayer>();
        try {
            list = this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)x, (double)y, (double)z));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return list;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("x", this.field_174879_c.func_177958_n());
        compound.func_74768_a("y", this.field_174879_c.func_177956_o());
        compound.func_74768_a("z", this.field_174879_c.func_177952_p());
        compound.func_74768_a("Range", this.range);
        return compound;
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SPacketUpdateTileEntity pkt) {
        this.range = pkt.func_148857_g().func_74762_e("Range");
    }

    @Override
    public void func_145839_a(@Nonnull NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.name = compound.func_74779_i("LocationName");
        this.range = Math.max(2, compound.func_74762_e("LocationRange"));
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K || this.name.isEmpty()) {
            return;
        }
        --this.ticks;
        if (this.ticks > 0) {
            return;
        }
        this.ticks = 10;
        List<EntityPlayer> around = this.getPlayerList(this.range, this.range, this.range);
        if (around.isEmpty()) {
            this.recentlyChecked = new ArrayList<EntityPlayer>();
            return;
        }
        List<EntityPlayer> toCheck = around;
        toCheck.removeAll(this.recentlyChecked);
        int rng = this.range + Math.min(this.range, 10);
        List<EntityPlayer> listMax = this.getPlayerList(rng, rng, rng);
        this.recentlyChecked.retainAll(listMax);
        toCheck.addAll(this.recentlyChecked);
        if (toCheck.isEmpty()) {
            return;
        }
        for (EntityPlayer player : toCheck) {
            PlayerData pdata = PlayerData.get(player);
            PlayerQuestData questData = pdata.questData;
            block1: for (QuestData data : questData.activeQuests.values()) {
                if (data.quest.step == 2 && data.quest.questInterface.isCompleted(player)) continue;
                boolean bo = data.quest.step == 1;
                for (IQuestObjective obj : data.quest.getObjectives((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player))) {
                    QuestInterface quest;
                    if (data.quest.step == 1 && !bo) continue block1;
                    bo = obj.isCompleted();
                    if (((QuestObjective)obj).getEnumType() != EnumQuestTask.LOCATION || !obj.getTargetName().equals(this.name) || !(quest = data.quest.questInterface).setFound(data, this.name)) continue;
                    if (data.quest.showProgressInWindow) {
                        NBTTagCompound compound = new NBTTagCompound();
                        compound.func_74768_a("QuestID", data.quest.id);
                        compound.func_74778_a("Type", "location");
                        compound.func_74783_a("Progress", new int[]{1, 1});
                        compound.func_74778_a("TargetName", obj.getTargetName());
                        compound.func_74768_a("MessageType", 0);
                        Server.sendData((EntityPlayerMP)player, EnumPacketClient.MESSAGE_DATA, compound);
                    }
                    if (data.quest.showProgressInChat) {
                        player.func_145747_a((ITextComponent)new TextComponentTranslation("quest.message.location.1", new Object[]{new TextComponentTranslation(obj.getTargetName(), new Object[0]).func_150254_d(), data.quest.getTitle()}));
                    }
                    questData.checkQuestCompletion(player, data);
                    questData.updateClient = true;
                }
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(@Nonnull NBTTagCompound compound) {
        if (!this.name.isEmpty()) {
            compound.func_74778_a("LocationName", this.name);
        }
        compound.func_74768_a("LocationRange", this.range);
        return super.func_189515_b(compound);
    }
}

